/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl.persist;

import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.persist.RbfHandleResponsePersistence;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HandleResponsePersistencePMImpl
implements RbfHandleResponsePersistence {
    private static final String TRACE_MASKT = "XRBFHPIT";
    private static final String TRACE_MASKF = "XRBFHPIF";
    private static final String TRACE_MASKD = "XRBFHPID";
    private static final String GRANDPARENT = "com.ibm.hwmca.fw.rbf";
    private static final String CHILD_RESPONSE = "handleresponse";

    public void storeResponse(RbfHandleResponse response) throws RbfException {
        RbfRequestId requestId = response.getRequestId();
        Trace.trace(TRACE_MASKT, "-> storeResponse() " + requestId);
        try {
            String parent = this.getParent(requestId);
            String responseChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_RESPONSE;
            PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
            persistMgr.write(responseChild, response);
        }
        catch (Exception e) {
            throw new RbfException(e);
        }
        Trace.trace(TRACE_MASKT, "<- storeResponse() " + requestId);
    }

    public RbfHandleResponse loadResponse(RbfRequestId requestId) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> loadResponse() " + requestId);
        String parent = "com.ibm.hwmca.fw.rbf." + this.removeChar(requestId.getUUID().toString(), '-');
        RbfHandleResponse response = this.loadResponse(parent);
        Trace.trace(TRACE_MASKT, "<- loadResponse() " + requestId);
        return response;
    }

    public List loadResponses() throws RbfException {
        Trace.trace(TRACE_MASKT, "-> loadResponses()");
        ArrayList<RbfHandleResponse> responses = new ArrayList<RbfHandleResponse>();
        try {
            PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
            List parentNames = persistMgr.readParentNames(GRANDPARENT);
            Iterator parents = parentNames.iterator();
            while (parents.hasNext()) {
                String parent = (String)parents.next();
                try {
                    RbfHandleResponse response = this.loadResponse(parent);
                    if (response == null) continue;
                    responses.add(response);
                }
                catch (RbfException rbfe) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RbfException(e);
        }
        Trace.trace(TRACE_MASKT, "<- loadResponses() " + responses.size());
        return responses;
    }

    private RbfHandleResponse loadResponse(String parent) throws RbfException {
        String responseChild = parent + "." + CHILD_RESPONSE;
        RbfHandleResponse response = null;
        try {
            PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
            response = (RbfHandleResponse)persistMgr.read(responseChild);
            if (response == null && !persistMgr.hasChildren(parent)) {
                persistMgr.delete(parent);
            }
        }
        catch (Exception e) {
            throw new RbfException(e);
        }
        return response;
    }

    public void removeResponse(RbfHandleResponse response) {
        RbfRequestId requestId = response.getRequestId();
        Trace.trace(TRACE_MASKT, "-> removeResponse() " + requestId);
        String parent = this.getParent(requestId);
        String responseChild = "com.ibm.hwmca.fw.rbf." + parent + "." + CHILD_RESPONSE;
        PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
        persistMgr.delete(responseChild);
        if (!persistMgr.hasChildren("com.ibm.hwmca.fw.rbf." + parent)) {
            persistMgr.delete("com.ibm.hwmca.fw.rbf." + parent);
        }
        Trace.trace(TRACE_MASKT, "<- removeResponse() " + requestId);
    }

    public void removeResponses(List responses) {
        Trace.trace(TRACE_MASKT, "-> removeResponses() " + responses.size());
        ListIterator iterator = responses.listIterator();
        while (iterator.hasNext()) {
            this.removeResponse((RbfHandleResponse)iterator.next());
        }
        Trace.trace(TRACE_MASKT, "<- removeResponses()");
    }

    private String getParent(RbfRequestId requestId) {
        return this.removeChar(requestId.getUUID().toString(), '-');
    }

    private String removeChar(String text, char theChar) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) != theChar) {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

